/**
 * 
 */
package orchestrator.plus;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import service.Transition;
import service.ComposedState;
import service.SimpleTransition;
import service.SimpleState;
import service.TransitionSystem;

/**
 * @author Giovanni
 *
 */
public class TransitionResultEntry implements Comparable<TransitionResultEntry>{
	private SimpleState targetState;
	private ComposedState composedState;
	private String action;
	private Vector<TransitionSystem<SimpleState,SimpleTransition>> ts;
	public TransitionResultEntry(SimpleState targetState,ComposedState composedState,Transition action){
		this.targetState=targetState;
		this.composedState=composedState;
		this.action=action.getName();
		this.ts=new Vector<TransitionSystem<SimpleState,SimpleTransition>>();
	}
	public TransitionResultEntry(SimpleState targetState,ComposedState composedState,Transition action,TransitionSystem<SimpleState, SimpleTransition> ts){
		this.targetState=targetState;
		this.composedState=composedState;
		this.action=action.getName();
		this.ts=new Vector<TransitionSystem<SimpleState,SimpleTransition>>();
		this.ts.add(ts);
	}
	public TransitionResultEntry(SimpleState targetState,ComposedState composedState,Transition action,Set<TransitionSystem<SimpleState, SimpleTransition>> ts){
		this.targetState=targetState;
		this.composedState=composedState;
		this.action=action.getName();
		this.ts=new Vector<TransitionSystem<SimpleState,SimpleTransition>>();
		this.ts.addAll(ts);
	}
	public void addTransitionSystemInTransition(TransitionSystem<SimpleState, SimpleTransition> ts){
		//check if already exist a ts with the same name
		Iterator<TransitionSystem<SimpleState,SimpleTransition>> itTS=this.ts.iterator();
		while(itTS.hasNext())
			if(itTS.next().getName().equals(ts.getName()))
				return;
		this.ts.add(ts);
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((action == null) ? 0 : action.hashCode());
		result = prime * result
				+ ((composedState == null) ? 0 : composedState.hashCode());
		result = prime * result
				+ ((targetState == null) ? 0 : targetState.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TransitionResultEntry other = (TransitionResultEntry) obj;
		if (action == null) {
			if (other.action != null)
				return false;
		} else if (!action.equals(other.action))
			return false;
		if (composedState == null) {
			if (other.composedState != null)
				return false;
		} else if (!composedState.equals(other.composedState))
			return false;
		if (targetState == null) {
			if (other.targetState != null)
				return false;
		} else if (!targetState.equals(other.targetState))
			return false;
		return true;
	}
	public String[] toStringArray(){
		String[] result=new String[]{
			targetState.getName(),
			"",
			action,
			""
		};
		for(int i=0;i<composedState.getStates().length;i++){
			try {
				if(i>0)
					result[1]=result[1]+",";
				result[1]=result[1]+composedState.getServicesState(i).getName();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		for(int i=0;i<ts.size();i++){
			if(i>0)
				result[3]=result[3]+",";
			result[3]=result[3]+ts.elementAt(i).getName();
		}			
		return result;
	}
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(TransitionResultEntry t) {
		int targetName=targetState.getName().compareTo(t.targetState.getName());
		if(targetName!=0)
			return targetName;
		int composedStateName=composedState.getName().compareTo(t.composedState.getName());
		if(composedStateName!=0)
			return composedStateName;
		int actionName=action.compareTo(t.action);
		if(actionName!=0)
			return actionName;
	
		return 0;
	}

}
